	function w = VON_HANN_WINDOW(N)
 	
	%	Computes the von Hann window, which is also know as Hanning window, 
	%	of length N+1
 
	%	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% Author: 			Lars Wanhammar 2008-07-12
	% Modified by: 	 	
	% Copyright:		by authors - not released for commercial use
	% Version:			1 
	% Known bugs:		
	% Report bugs to:	Wanhammar@gmail.com
	
	M = N+1;
	for n = 1:M
		w(n) = 0.5*(1 - cos(2*pi*n/M));
	end
